/* =  Keithley 197a System DMM Include File ==================================== */
/* = GLOBAL FUNCTION DECLARATIONS ============================================= */
void kei197a_init (int);
void kei197a_close (void);
void kei197a_queryMeasurementFunction (char [], int *);
void kei197a_queryAllFunctions (char [], int *,
								char [], int *,
								char [], int *,
								char [], int *);
void kei197a_setdBMode (int);
void kei197a_setMeasurementRange (double);
void kei197a_setRelativeMode (int);
void kei197a_setTriggerMode (int);
void kei197a_sendTrigger (int);
void kei197a_measure(double *);

/* = GLOBAL VARIABLE DECLARATIONS ============================================= */
/* Global error variable for the instrument module */
extern int kei197a_err;

/* CONSTANTS */

/* FUNCTIONS */

#define FUNC_DC_VOLTS 	0 
#define FUNC_AC_VOLTS 	1
#define FUNC_OHMS 		2
/* NO value for 3 */
#define FUNC_DC_AMPS 	4
#define FUNC_AC_AMPS 	5
#define FUNC_DC_dB 	6
#define FUNC_AC_dB 	7

/* RANGES */

#define RANGE_AUTO 	0
#define RANGE_200mV 1
#define RANGE_2V	2
#define RANGE_20V	3
#define RANGE_200V	4
#define RANGE_1kV 	5

#define RANGE_200_OHMS	1
#define RANGE_2k_OHMS	2
#define RANGE_20k_OHMS	3
#define RANGE_200k_OHMS	4
#define RANGE_1M_OHMS	5

#define RANGE_200uA	1
#define RANGE_2mA	2
#define RANGE_20mA	3
#define RANGE_200mA	4
#define RANGE_2A	5
#define RANGE_10A	6

/* TRIGGER MODE VALUES */

#define TRIG_CONT_TALK		0
#define TRIG_ONESHOT_TALK	1
#define TRIG_CONT_GET		2
#define TRIG_ONESHOT_GET	3
#define TRIG_CONT_X			4
#define TRIG_ONESHOT_X		5

/* ERROR CODES not contained in LabWindows/CVI */

#define KEI197a_INVALID_RANGE	 			1000
#define KEI197a_INVALID_FUNCTION			1001
#define KEI197a_AMPS_RANGE_NOT_PROGRAMMABLE 1002
#define KEI197a_INVALID_dB_FUNCTION_REQUEST 1003

/* MISC. VALUES */

#define KEI197a_OFF	0
#define KEI197a_ON	1

/* MODIFIERS FOR send_trigger */

#define KEI197a_SENDGET 1
#define KEI197a_SENDX	2




